﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.Xml;

public partial class Admin_NeiRong_ShiPin_XiuGai : System.Web.UI.Page
{
    private 访问 访问;
    protected String 分类代码;
    protected new int ID;
    protected String 栏目名称;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改视频", "网站后台", "修改视频", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private String 获取栏目(int ID)
    {
        String 返回值;

        SqlCommand 语句 = new SqlCommand("SELECT [栏目名称] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [ID]=" + ID, 访问.连接);
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            返回值 = Convert.ToString(读取["栏目名称"]);
        else
            返回值 = null;
        读取.Close();

        return 返回值;
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        ID = Convert.ToInt32(Request.QueryString["ID"]);
        if (this.IsPostBack)
            修改视频();
        else
            初始化视频();
    }

    private void 修改视频()
    {
        访问.验证权限("42");
        String 标题 = BiaoTi.Text;
        String 标题样式_颜色 = BiaoTiYangShi_YanSe.Text;
        bool 标题样式_粗体 = BiaoTiYangShi_ChuTi.Checked;
        bool 标题样式_斜体 = BiaoTiYangShi_XieTi.Checked;
        bool 标题样式_删除线 = BiaoTiYangShi_ShanChuXian.Checked;
        String 外部链接 = WaiBuLianJie.Text;
        DateTime 发布时间 = Convert.ToDateTime(FaBuShiJian.Text);
        bool 是否推荐 = ShiFouTuiJian.Checked;
        String 视频简介 = ShiPinJianJie.Text;
        bool 是否关闭评论 = ShiFouGuanBiPingLun.Checked;
        int 内容模板 = Convert.ToInt32(NeiRongMoBan.SelectedValue);
        int 内容模板_3G = Convert.ToInt32(NeiRongMoBan_3G.SelectedValue);
        int 评论模板 = Convert.ToInt32(PingLunMoBan.SelectedValue);
        int 评论模板_3G = Convert.ToInt32(PingLunMoBan_3G.SelectedValue);
        bool 权限_仅限会员 = QuanXian_JinXiaoHuiYuan.Checked;
        int 权限_需要等级 = Convert.ToInt32(QuanXian_XuYaoDenJi.Text);
        int 权限_扣除积分 = Convert.ToInt32(QuanXian_KouChuJiFen.Text);

        if (标题 == "" || 标题 == null)
            throw new Exception("标题不能为空");

        SqlCommand 语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_视频_视频] SET [标题]=@标题" +
            ",[标题样式_颜色]=@标题样式_颜色" +
            ",[标题样式_粗体]=@标题样式_粗体" +
            ",[标题样式_斜体]=@标题样式_斜体" +
            ",[标题样式_删除线]=@标题样式_删除线" +
            ",[外部链接]=@外部链接" +
            ",[发布时间]=@发布时间" +
            ",[是否推荐]=@是否推荐" +
            ",[视频简介]=@视频简介" +
            ",[是否关闭评论]=@是否关闭评论" +
            ",[内容模板]=@内容模板" +
            ",[3G内容模板]=@3G内容模板" +
            ",[评论模板]=@评论模板" +
            ",[3G评论模板]=@3G评论模板" +
            ",[权限_仅限会员]=@权限_仅限会员" +
            ",[权限_需要等级]=@权限_需要等级" +
            ",[权限_扣除积分]=@权限_扣除积分 WHERE [ID]=" + ID, 访问.连接);
        语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 标题;
        语句.Parameters.Add("@标题样式_颜色", SqlDbType.NVarChar).Value = 标题样式_颜色;
        语句.Parameters.Add("@标题样式_粗体", SqlDbType.Bit).Value = 标题样式_粗体;
        语句.Parameters.Add("@标题样式_斜体", SqlDbType.Bit).Value = 标题样式_斜体;
        语句.Parameters.Add("@标题样式_删除线", SqlDbType.Bit).Value = 标题样式_删除线;
        语句.Parameters.Add("@外部链接", SqlDbType.NVarChar).Value = 外部链接;
        语句.Parameters.Add("@发布时间", SqlDbType.DateTime).Value = 发布时间;
        语句.Parameters.Add("@是否推荐", SqlDbType.Bit).Value = 是否推荐;
        语句.Parameters.Add("@视频简介", SqlDbType.NVarChar).Value = 视频简介;
        语句.Parameters.Add("@是否关闭评论", SqlDbType.Bit).Value = 是否关闭评论;
        语句.Parameters.Add("@内容模板", SqlDbType.Int).Value = 内容模板;
        语句.Parameters.Add("@3G内容模板", SqlDbType.Int).Value = 内容模板_3G;
        语句.Parameters.Add("@评论模板", SqlDbType.Int).Value = 评论模板;
        语句.Parameters.Add("@3G评论模板", SqlDbType.Int).Value = 评论模板_3G;
        语句.Parameters.Add("@权限_仅限会员", SqlDbType.Bit).Value = 权限_仅限会员;
        语句.Parameters.Add("@权限_需要等级", SqlDbType.Int).Value = 权限_需要等级;
        语句.Parameters.Add("@权限_扣除积分", SqlDbType.Int).Value = 权限_扣除积分;
        语句.ExecuteNonQuery();

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("修改视频[" + 标题 + "]", 访问.用户["昵称"].ToString());

        Response.Redirect(Request.QueryString["rurl"]);
    }

    private void 初始化视频()
    {

        NeiRongMoBan.Items.Add(new ListItem("默认模板", "0"));
        NeiRongMoBan_3G.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan_3G.Items.Add(new ListItem("默认模板", "0"));

        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 程序.设置["默认模板"] + "/Content/")).GetFiles();

        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            String _内容类型 = "";
            bool 是否WAP = true;

            XmlReader 读取 = XmlReader.Create(FIS[i].OpenRead());
            while (读取.Read())
                if (读取.NodeType == XmlNodeType.Element)
                    if (读取.Name == "set")
                        if (读取.GetAttribute("name") == "ID")
                            ID = Convert.ToInt32(读取.GetAttribute("value"));
                        else if (读取.GetAttribute("name") == "模板名称")
                            模板名称 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "模板类型")
                            模板类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "内容类型")
                            _内容类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "是否WAP")
                            是否WAP = Convert.ToBoolean(读取.GetAttribute("value"));
            读取.Close();

            if (_内容类型 == "视频")
                switch (模板类型)
                {
                    case "查看内容":
                        if (是否WAP)
                            NeiRongMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            NeiRongMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                    case "评论列表":
                        if (是否WAP)
                            PingLunMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            PingLunMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                }
        }

        Hashtable 视频 = 常用.SQL_获取(new SqlCommand("SELECT * FROM [" + 程序.数据表前缀 + "内容_视频_视频] WHERE [ID]=" + this.ID, 访问.连接));

        if (视频 == null)
            throw new Exception("视频不存在");

        SqlCommand 语句 = new SqlCommand("SELECT [栏目名称] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [ID]=" + Convert.ToInt32(视频["所属栏目"]), 访问.连接);
        SqlDataReader _读取 = 语句.ExecuteReader();
        if (_读取.Read())
            分类代码 = "<a href=\"" + Server.HtmlEncode(Request.QueryString["rurl"]) + "\">" + Server.HtmlEncode(_读取["栏目名称"].ToString()) + "</a> &gt;";
        else
        {
            _读取.Close();
            throw new Exception("内容栏目不存在");
        }
        _读取.Close();

        BiaoTi.Text = Convert.ToString(视频["标题"]);
        BiaoTiYangShi_YanSe.Text = Convert.ToString(视频["标题样式_颜色"]);
        BiaoTiYangShi_ChuTi.Checked = Convert.ToBoolean(视频["标题样式_粗体"]);
        BiaoTiYangShi_XieTi.Checked = Convert.ToBoolean(视频["标题样式_斜体"]);
        BiaoTiYangShi_ShanChuXian.Checked = Convert.ToBoolean(视频["标题样式_删除线"]);
        WaiBuLianJie.Text = Convert.ToString(视频["外部链接"]);
        FaBuShiJian.Text = Convert.ToString(视频["发布时间"]);
        ShiFouTuiJian.Checked = Convert.ToBoolean(视频["是否推荐"]);
        ShiPinJianJie.Text = Convert.ToString(视频["视频简介"]);

        String 图片文件 = "";
        String[] 图片数组 = Convert.ToString(视频["视频图片"]).Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);

        for (int i = 0; i < 图片数组.Length; i++)
            图片文件 += "<img src=\"" + Server.HtmlEncode(图片数组[i]) + "\" alt=\"\" style=\"width:90px;height:90px\" />";

        String 视频文件 = "";
        String[] 文件数组 = Convert.ToString(视频["视频文件"]).Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);

        for (int i = 0; i < 文件数组.Length; i++)
            视频文件 += Server.HtmlEncode(文件数组[i]) + "<br/>";

        TuPianWenJian.Text = 图片文件;
        ShiPinWenJian.Text = 视频文件;
        ShiFouGuanBiPingLun.Checked = Convert.ToBoolean(视频["是否关闭评论"]);
        NeiRongMoBan.SelectedValue = Convert.ToString(视频["内容模板"]);
        NeiRongMoBan_3G.SelectedValue = Convert.ToString(视频["3G内容模板"]);
        PingLunMoBan.SelectedValue = Convert.ToString(视频["评论模板"]);
        PingLunMoBan_3G.SelectedValue = Convert.ToString(视频["3G评论模板"]);
        QuanXian_JinXiaoHuiYuan.Checked = Convert.ToBoolean(视频["权限_仅限会员"]);
        QuanXian_XuYaoDenJi.Text = Convert.ToString(视频["权限_需要等级"]);
        QuanXian_KouChuJiFen.Text = Convert.ToString(视频["权限_扣除积分"]);
    }
}
